* UTHERNET DRIVER
* PACKETPAGE ADDRESSES
BUSSTAT EQU $0138
RECVFBYTC EQU $0050 ; RECEIVED FRAME BYTE COUNTER
RECVCONF EQU $0102 ; RECEIVER CONFIGURATION
RECVEVNT EQU $0124 ; RECEIVER EVENT
RECVCTL EQU $0104 ; RECEIVER CONTROL
TXCMDST EQU $0108 ; TRANSMIT COMMAND STATUS
TXEVENT EQU $0128 ; TRANSMITTER EVENT
LINECTL EQU $0112 ; LINE CONTROL
LINESTAT EQU $0134 ; LINE STATUS
SELFSTAT EQU $0136 ; SELF STATUS
SELFCTL EQU $0114 ; SELF CONTROL
MACADDR EQU $0158 ; MAC ADDRESS
RXMISS EQU $0130 ; MISSED FRAME COUNT (UPPER 10 BITS)
*
* SLOT I/O EQUATES
UTHID EQU $630E ; CS8900A ID BYTES
 DO DEBUG
US EQU $20
 ELSE
USLOT KBD "UTHERNET SLOT"
US EQU USLOT*16
 FIN
PPLO EQU $C08A+US ; SLOT 3 PP POINTER LO-BYTE
PPHI EQU $C08B+US ; PP POINTER HI-BYTE
PDLO EQU $C08C+US ; PP DATA LO-BYTE
PDHI EQU $C08D+US ; PP DATA HI-BYTE
TXCMDLO EQU $C084+US ; TRANSMIT COMMAND LO-BYTE
TXCMDHI EQU $C085+US ; TRANSMIT COMMAND HI-BYTE
TXLENLO EQU $C086+US ; TRANSMISSION LENGTH LO-BYTE
TXLENHI EQU $C087+US ; TRANSMISSION LENGTH HI-BYTE
RXTXDATLO EQU $C080+US ; RECEIVE/TRANSMIT DATA LO-BYTE
RXTXDATHI EQU $C081+US ; RECEIVE/TRANSMIT DATA HI-BYTE
*
*
* OUR MAC ADDRESS STORED HERE
OURMAC HEX 0080106D7630
*
SLOTNO DFB 0 ; SLOT IN $N0 FORMAT
TXFAILS DFB 0 ; HOW MANY TX FAILURES
FIXEDDEST DFB 0 ; NOT A FIXED DEST INTERFACE
*
* OUTGOING PROTOCOL HEADERS STORED HERE
* THESE ARE:
* 14 BYTE ETHERNET HEAD
* 20 BYTE IP HEAD
* UP TO 32 BYTES UDP OR TCP HEAD
OUTPHEAD
 HEX FFFFFFFFFFFF ; DESTINATION MAC
 HEX 000000000000 ; SOURCE MAC
 HEX 0800   ; ETHERTYPE IP
 HEX 450000000000
 HEX 0000FF110000
 HEX 00000000   ; IP SOURCE
 HEX FFFFFFFF   ; IP DESTINATION
 DS 32   ; UDP OR TCP HEAD
*
* FIND UTHERNET CARD
*
ETHFIND
 LDY #USLOTLEN-USLOTS ; NUMBER OF SLOTS TO SCAN
:L LDA USLOTS,Y ; GET SLOT NUMBER
 TAX
*
* CHECK TXCMD
*
 LDA $C084,X
 AND #%00111111
 CMP #9
 BNE :NEXTSLOT
*
* CHECK PRODUCT ID BYTES
*
 LDA #0 ; ENSURE LO-BYTE OF PP POINTER IS 0
 STA $C08A,X
 STA $C08B,X ; SET HI-BYTE TOO
 LDA $C08D,X
 CMP #>UTHID ; COMPARE HI-BYTE OF ID
 BNE :NEXTSLOT ; NO MATCH
 LDA $C08C,X ; GET LO-BYTE OF ID
 CMP #<UTHID ; COMPARE LO-BYTE
 BNE :NEXTSLOT
*
* PROBE SUCCESSFUL
*
 STX SLOTNO
 DO DEBUG
 LDY #0
:L2 LDA MSG2,Y
 BEQ :LDONE
 JSR COUT
 INY
 BNE :L2
 FIN
:LDONE JMP ETHINIT ; INITIALIZE UTHERNET CARD
*
* TRY NEXT SLOT
*
:NEXTSLOT
 DEY
 BPL :L
*
* UTHERNET NOT FOUND
*
 JMP DOSWARM
*
USLOTS HEX 70605010204030
USLOTLEN
*
*
*
* SEND AN ETHERNET FRAME
*
* AS OF THE JAN 2016 EDITION OF MARINA, THE OLD SEND
* FUNCTION IS DEPRECATED IN FAVOR OF SEND16.
*
ETHSEND
 LDA #0
 STA OUTPHLEN ; NO PROTOCOL HEADERS
*
*
* SEND16
*
* THIS IS THE HIGH-LEVEL SEND ROUTINE THAT USES A 16-BIT POINTER
* TO SEND UP TO 1514 BYTES (INCLUDING 14 BYTE ETH HEADER).
* THERE ARE TWO POINTERS. ONE IS FOR OUTPHEAD WHICH HOLDS THE
* ETHERNET, IP, AND UDP HEADERS. THE SECOND IS FOR OUTPDAT
* WHICH HOLDS THE USER'S DATA IN THE UDP PACKET. THIS DESIGN IS
* INTENDED TO ELIMINATE THE NEED TO COPY A LARGE BLOCK OF DATA.
*
* THIS SUBROUTINE DOES NOT MODIFY ANY DATA. YOUR PACKET NEEDS TO
* BE COMPLETELY READY TO SEND BEFORE YOU CALL THIS!
*
* IT ALSO DOES NOT MODIFY OUTPLEN. YOU NEED TO HAVE THE USER'S
* DATA LENGTH + HEADER LENGTH (42 FOR STANDARD UDP) STORED HERE.
*
ETHSEND16 LDA #$C9 ; LO-BYTE OF TRANSMIT REQUEST COMMAND
 LDY #0 ; HI-BYTE
 STA TXCMDLO
 STY TXCMDHI
 LDA OUTPLEN ; LO-BYTE OF ETHERNET FRAME LENGTH
 LDY OUTPLEN+1 ; HI-BYTE
 STA TXLENLO
 STY TXLENHI ; STORE HI-BYTE OF TRANSMISSION LENGTH
 LDA #<BUSSTAT ; LO-BYTE OF BUS STATUS REGISTER
 LDY #>BUSSTAT ; HI-BYTE
 STA PPLO ; STORE LO-BYTE IN PP ADDRESS REGISTER
 STY PPHI ; STORE HI-BYTE
 LDY #5 ; RETRIES COUNTER
:CHECK LDA PDHI ; GET HI-BYTE OF BUS STATUS
 LSR  ; SEND BIT 8 (READY TO SEND) TO CARRY FLAG
 BCS :READY ; READY TO SEND?
 LDA #48 ; NO, SO WAIT A BIT
 JSR WAIT ; WAIT, ACCUM SET TO 0
 DEY
 BPL :CHECK ; POLL AGAIN
* ERROR
:ERR
 LDY #0
:LM LDA MSG13,Y
 BEQ :NEXTERR
 JSR COUT
 INY
 BNE :LM
:NEXTERR SEC  ; ERROR
 RTS
*
* SEND THE PROTOCOL HEADERS
*
:READY
 LDA OUTPHLEN ; ANY HEADERS TO SEND?
 BEQ :SENDBOD ; NO HEADERS
 LDY #0 ; COUNTER FOR BYTES SENT
:L LDA OUTPHEAD,Y ; LOAD BYTE TO SEND
 STA RXTXDATLO ; SEND TO CS8900A TRANSMIT DATA PORT (LO)
 INY ; POINT TO NEXT DATA BYTE
 LDA OUTPHEAD,Y ; LOAD NEXT BYTE TO SEND
 STA RXTXDATHI ; SEND TO TRANSMIT DATA PORT (HI)
 INY
 CPY OUTPHLEN ; SENT ALL HEAD BYTES YET?
 BNE :L ; NO, SO CONTINUE
* NOW WE SUBTRACT OUTPHLEN FROM OUTPLEN AND ENSURE THAT
* THE RESULT IS EVEN. HAVING ZERO IS ALSO
* ACCEPTABLE, AND WE EXIT CLEANLY IN THIS CASE.
 SEC
 LDA OUTPLEN
 SBC OUTPHLEN ; HEADER LENGTH
 STA OUTPLEN
 LDA OUTPLEN+1
 SBC #0
 STA OUTPLEN+1
 LDA OUTPLEN
 LSR  ; TEST FOR ODD
 BCC :SENDBOD ; EVEN, SO SEND NOW
 CLC  ; IT'S ODD, SO ADD 1
 INC OUTPLEN
 BNE :SENDBOD
 INC OUTPLEN+1
*
* THIS IS WHERE WE SEND THE USER'S PACKET DATA
*
:SENDBOD
 LDY #0
 LDA OUTPLEN+1
 BEQ :END ; ONLY ONE PAGE OF DATA TO SEND
 TAX  ; OUTPLEN+1 IS NOW IN X
:L2 LDA (OUTPBUF),Y
 STA RXTXDATLO
 INY
 LDA (OUTPBUF),Y
 STA RXTXDATHI
 INY
 BNE :L2
 INC OUTPBUF+1
 DEX  ; NEXT BLOCK OF 256 BYTES
 BNE :L2
 LDA OUTPLEN
 BEQ :DONE ; EXACT MULTIPLE OF 256
:END
 LDA (OUTPBUF),Y
 STA RXTXDATLO
 INY
 LDA (OUTPBUF),Y
 STA RXTXDATHI
 INY
 CPY OUTPLEN ; DONE YET?
 BNE :END
:DONE
 LDA #$FF ; TIMEOUT COUNTER
 PHA
:DONE2
 PLA
 TAY
 DEY
 BEQ :TIMEOUT
 TYA
 PHA
 LDA #<TXEVENT ; CHECK TXOK
 STA PPLO
 LDA #>TXEVENT
 STA PPHI
 LDA PDHI ; TXOK IS BIT 0
 LDY PDLO
 TAY
 LSR
 BCS :DONEOK
 TYA ; TEST FOR ERROR
 AND #%10000110
 BEQ :DONE2 ; PROBABLY NOT DONE TRANSMITTING
* IF WE GET HERE, THERE'S BEEN A TRANSMISSION ERROR
* PROBABLY CAUSED BY THE LINK BEING DOWN
:TIMEOUT
 INC TXFAILS
 JMP :ERR
*
:DONEOK
 PLA
 CLC ; NO ERROR
 RTS
*
*
* POLL THE CS8900A FOR AN INCOMING FRAME.
* IF THERE ISN'T ONE, THEN WE RETURN WITH CARRY FLAG SET.
* BUT IF THERE IS ONE, THEN WE COPY IT TO THE APPLE.
*
ETHINPOLL
 LDA #<RECVEVNT ; LOW-BYTE OF RECEIVER EVENT REGISTER
 LDY #>RECVEVNT ; HI-BYTE
 STA PPLO ; STORE LOW-BYTE IN PACKETPAGE ADDR.
 STY PPHI
 LDA #%00001100 ; CHECK BITS 2 OR 3 SET IN STATUS BYTE
 BIT PDHI ; GET HI-BYTE OF RECEIVE EVENT AND CHECK
 BNE :GETLEN ; VALID INCOMING PACKET?
 SEC ; NO, SO SET C FLAG...
 RTS  ; ...AND EXIT
:GETLEN
 LDA #0
 STA LLBCASTFLAG
 LDA RXTXDATHI ; HI-BYTE OF RECEIVE STATUS
 AND #%00001000 ; BROADCAST FLAG SET?
 BEQ :NOLLBCAST ; NO, CONTINUE
 LDA #$FF
 STA LLBCASTFLAG ; SET LINK BROADCAST FLAG
:NOLLBCAST
 LDA RXTXDATLO ; LO-BYTE OF RXSTATUS, DISCARD
 LDY RXTXDATHI ; HI-BYTE OF INCOMING FRAME LENGTH
 LDA RXTXDATLO ; LO-BYTE
 STA INPLEN ; STORE LO-BYTE OF FRAME LENGTH
 STY INPLEN+1
*
*
*
* RECEIVE AN ETHERNET FRAME
*
* CALL THIS SUBROUTINE WHEN YOU HAVE ALREADY CHECKED
* THAT THE UTHERNET HAS RECEIVED A FRAME. YOU NEED TO HAVE
* STORED THE INCOMING FRAME LENGTH AT INPLEN BEFORE YOU
* CALL THIS SUBROUTINE.
* FOR NOW, ALL INCOMING FRAMES ARE STORED AT $5000
*
ETHRECV
 INC RNDL
 BNE :NEXT
 INC RNDH
:NEXT LDA INPLEN+1 ; SAVE HI-BYTE
 PHA  ; ON THE STACK FOR LATER
 LDA #0 ; LO-BYTE OF DEST. BUFFER
 STA INPBUF
 LDA #$50 ; HI-BYTE OF DEST. BUFFER
 STA INPBUF+1
 LDY #0 ; INITIALIZE OFFSET INDEX
 LDX INPLEN ; GET LO-BYTE
:READTOP LDA RXTXDATLO ; FIRST BYTE FROM UTHERNET
 STA (INPBUF),Y ; STORE IN BUFFER
 INY
 BNE :READMID
 INC INPBUF+1
:READMID DEX
 CPX #$FF ; WRAPPED BACK?
 BNE :RM2
 DEC INPLEN+1
 LDA INPLEN+1
 CMP #$FF
 BEQ :DONE
:RM2 LDA RXTXDATHI ; 2ND BYTE FROM UTHERNET
 STA (INPBUF),Y ; STORE
 INY
 BNE :READBOTTOM ; NOT WRAPPED OVER
 INC INPBUF+1 ; INCR. HI-BYTE OF DEST. ADDR.
:READBOTTOM DEX
 CPX #$FF ; LO-BYTE WRAPPED AROUND?
 BNE :READTOP ; NO, SO CONTINUE INNER LOOP
:ENDIL DEC INPLEN+1
 LDA INPLEN+1
 CMP #$FF ; WRAPPED OVER?
 BEQ :DONE ; YES, SO COPY IS DONE
 BNE :READTOP ; START INNER LOOP
:DONE PLA
 STA INPLEN+1
 LDA #0 ; RESTORE INPBUF
 STA INPBUF
 LDA #$50
 STA INPBUF+1
 CLC
 RTS
*
*
* INITIALIZE THE ETHERNET CARD
*
ETHINIT
 LDA #<SELFCTL ; LO-BYTE OF SELF CONTROL REGISTER ADDR
 LDY #>SELFCTL ; HI-BYTE
 STA PPLO ; STORE LO-BYTE IN PP ADDRESS REGISTER
 STY PPHI ; STORE HI-BYTE
 LDA #%01010101 ; LO-BYTE OF RESET CONFIG
 LDY #0 ; HI-BYTE IS ALL 0
 STA PDLO ; STORE LO-BYTE IN PP DATA REGISTER
 STY PDHI ; STORE HI-BYTE. THE CS8900A RESETS NOW
*
* WAIT FOR INITIALIZATION TO COMPLETE
*
:CHKINIT LDA #<SELFSTAT
 LDY #>SELFSTAT
 STA PPLO
 STY PPHI
 LDY PDLO ; WE WANT BIT 7, INITD
 LDA PDHI ; DON'T CARE
 TYA  ; CONDITION THE N FLAG
 NOP
 BPL :CHKINIT ; NOT READY
*
 LDA #<RECVCTL ; LO-BYTE OF RECEIVER CONTROL REGISTER
 LDY #>RECVCTL ; HI-BYTE
 STA PPLO ; STORE LO-BYTE IN PP ADDRESS REGISTER
 STY PPHI ; STORE HI-BYTE
*
* RECEIVE CONTROL: ACCEPT VALID INDIVIDUAL AND BROADCAST FRAMES
*
 LDA #%00000101 ; LO-BYTE OF RECEIVE CONTROL
 DO MULTICAST
 LDY #%00001111 ; HI-BYTE OF RECEIVE CONTROL
 ELSE
 LDY #%00001101
 FIN
 STA PDLO ; STORE LO-BYTE OF CONTROL
 STY PDHI ; STORE HI-BYTE OF CONTROL
*
* ASSIGN MAC ADDRESS
*
ASSIGNMAC
 LDA #<MACADDR ; LO-BYTE OF MAC ADDRESS LOCATION
 LDY #>MACADDR
 STA PPLO ; STORE LO-BYTE IN PP POINTER
 STY PPHI ; STORE HI-BYTE
 LDA OURMAC ; FIRST BYTE OF MAC ADDRESS
 LDY OURMAC+1 ; SECOND BYTE
 STA PDLO ; STORE LO-BYTE IN DATA REGISTER
 STY PDHI ; STORE HI-BYTE
 LDA #MACADDR+2 ; INCR. MAC ADDRESS LOCATION
 STA PPLO
 LDA OURMAC+2 ; 3RD BYTE OF MAC ADDR
 LDY OURMAC+3 ; 4TH BYTE
 STA PDLO
 STY PDHI
 LDA #MACADDR+4
 STA PPLO ; UPDATE PP POINTER FOR LAST TWO BYTES
 LDA OURMAC+4 ; 5TH BYTE
 LDY OURMAC+5 ; 6TH AND FINAL BYTE OF MAC ADDR
 STA PDLO
 STY PDHI ; MAC ADDRESS IS ASSIGNED
* COPY OURMAC INTO OUTPHEAD
 LDX #5 ; OFFSET FOR OURMAC
 LDY #11 ; OFFSET FOR OUTPHEAD
:OML LDA OURMAC,X
 STA OUTPHEAD,Y
 DEY
 DEX
 BPL :OML
ALLOWTX   ; ALLOW CS8900A TO SEND AND RECV
 LDA #<LINECTL ; LO-BYTE OF LINE CONTROL ADDRESS
 LDY #>LINECTL ; HI-BYTE
 STA PPLO ; STORE LO-BYTE IN PP POINTER
 STY PPHI
 LDA #$D3 ; LO-BYTE OF LINE CTL TURNS ON SEND AND RECV
 DEY  ; HI-BYTE IS ZERO
 STA PDLO ; STORE LO-BYTE TO PP DATA
 STY PDHI ; STORE HI-BYTE
 LDA #0
 STA TXFAILS
 CLC ; NO ERRORS!
 RTS ; DONE WITH INITIALIZATION
